var KasperskyLab = (function (ns)
{

ns.Balloon = function(createCallback, updateCallback, cssPostfix)
{
	var Initializing = 0;
	var Ready = 1;

	var m_balloon = null;
	var m_isDisplayed = false;
	var m_state = Initializing;
	var m_currentGetCoordCallback = EmptyCoordCallback;

	function EmptyCoordCallback()
	{
		throw new Error("empty coord callback");
	}

	function GetFrameDocument(frameNode)
	{
		return frameNode.contentDocument || frameNode.contentWindow.document;
	}

	function FillFrame(setupBalloonCallback)
	{
		var frameDocument = GetFrameDocument(m_balloon);
		if (frameDocument && frameDocument.body && !frameDocument.filled)
		{
			var fillBodyFunc = function()
				{
					if (frameDocument.body && frameDocument.body.childNodes.length === 0)
					{
						if (ns.IsRtl)
							frameDocument.body.className = "rtl";
						createCallback(frameDocument.body, frameDocument);
						setupBalloonCallback();
					}
				};

			if (cssPostfix)
			{
				ns.AddCssLink(frameDocument, ns.GetResourceSrc(cssPostfix), fillBodyFunc, function()
					{
						frameDocument.open().write("<html><head><link type=\"text/css\" rel=\"stylesheet\" href=\"" + ns.GetResourceSrc(cssPostfix) + "\"></head><body></body></html>");
						frameDocument.close();
						ns.AddEventListener(frameDocument, "load", fillBodyFunc);
						ns.SessionLog("error loading " + cssPostfix);
					});
			}
			else
			{
				fillBodyFunc();
			}
			frameDocument.filled = true;	
		}
	}

	function CreateBalloon(setupBalloonCallback)
	{
		m_balloon = document.createElement("iframe");
		m_balloon.scrolling = "no";
		m_balloon.frameBorder = "0";
		m_balloon.style.zIndex = "2147483647";
		m_balloon.style.border = "0";
		m_balloon.style.position = "absolute";
		m_balloon.allowTransparency = "true"; 
		HideBalloon();

		document.body.appendChild(m_balloon);

		try
		{
			ns.AddIframeDoctype(m_balloon);
			FillFrame(setupBalloonCallback);
		}
		catch (e)
		{
			m_balloon.src = 'javascript:(function () {' +'document.open();document.domain=\'' + document.domain + '\';document.close();' + '})();';
			ns.SetTimeout(
				function()
				{
					try
					{
						ns.AddIframeDoctype(m_balloon);
						FillFrame(setupBalloonCallback);
					}
					catch (e)
					{
						m_balloon.src = "javascript:'<script>window.onload=function(){document.write(\\'<script>document.domain=\\\"" + document.domain + "\\\";<\\\\/script>\\');document.close();};<\/script>'";
						ns.SetTimeout(
							function()
							{
								ns.AddIframeDoctype(m_balloon);
								FillFrame(setupBalloonCallback);
							}, 0);
					}
				}, 0);
		}
		ns.SetTimeout(
			function()
			{
				FillFrame(setupBalloonCallback);
			}, 100);
	}

	function GetElementSize(element)
	{
		return { width: element.scrollWidth, height: element.scrollHeight };
	}

	function HideBalloon()
	{		
		if (m_balloon)
			m_balloon.style.display = "none";
	}

	function ResizeBalloon(element)
	{
		var balloonSize = GetElementSize(element);
		m_balloon.style.height = balloonSize.height + "px";
		m_balloon.style.width = balloonSize.width + "px";
		return balloonSize;
	}

	function SetupBalloon()
	{
		m_state = Ready;

		m_balloon.style.display = m_isDisplayed ? "" : "none";
		m_balloon.style.height = "1px";
		m_balloon.style.width = "1px";
		m_balloon.style.left = "1px";
		m_balloon.style.top = "1px";

		var frameDocument = GetFrameDocument(m_balloon);
		if (updateCallback)
			updateCallback(frameDocument);

		var balloonSize = ResizeBalloon(frameDocument.body);

		var coords = m_currentGetCoordCallback(balloonSize);
		m_balloon.style.left = Math.round(coords.x).toString() + "px";
		m_balloon.style.top = Math.round(coords.y).toString() + "px";
	}

	this.Show = function(getCoordCallback)
	{
		m_currentGetCoordCallback = getCoordCallback;
		m_isDisplayed = true;
		if (!m_balloon)
			CreateBalloon(SetupBalloon);
		else if (m_state === Ready)
			SetupBalloon();
	}

	this.Hide = function()
	{
		m_currentGetCoordCallback = EmptyCoordCallback;
		m_isDisplayed = false;
		if (m_balloon)
			m_balloon.blur(); 
		HideBalloon();
	}

	this.Update = function()
	{
		if (m_isDisplayed)
			SetupBalloon();
	}
};
return ns;

}) (KasperskyLab || {});
